% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda-config.R
\name{lambda_config}
\alias{lambda_config}
\title{Set up endpoints, variables, and configuration for AWS Lambda}
\usage{
lambda_config(
  handler = NULL,
  runtime_api = NULL,
  task_root = NULL,
  deserialiser = NULL,
  serialiser = NULL,
  decode_base64 = TRUE,
  environ = parent.frame()
)
}
\arguments{
\item{handler}{the function to use for processing inputs from
events. The "_HANDLER" environment variable, as configured in AWS, will
always override this value if present.}

\item{runtime_api}{character. Used as the host in the various endpoints used
by AWS Lambda. This argument is provided for debugging and testing only.
The "AWS_LAMBDA_RUNTIME_API" environment variable, as configured by AWS,
will always override this value if present.}

\item{task_root}{character. Defines the path to the Lambda function code.
This argument is provided for debugging and testing only. The
"LAMBDA_TASK_ROOT" environment variable, as configured by AWS, will always
override this value if present.}

\item{deserialiser}{function for deserialising the body of the event. By
default, will attempt to deserialise the body as JSON, based on whether the
input is coming from an API Gateway, scheduled Cloudwatch event, or direct.
To use the body as is, pass the \code{identity} function. To ignore the event
content, pass \code{function(x) list()}. See the vignettes for details on
parsing invocations from particular sources.}

\item{serialiser}{function for serialising the result before sending.
By default, will attempt to serialise the body as JSON, based on the
request type. To send the result as is, pass the \code{identity} function.}

\item{decode_base64}{logical. Should Base64 input be automatically decoded?
This is only used for events coming via an API Gateway. Complicated input
(such as images) may be better left as is, so that the handler function can
deal with it appropriately. Defaults to \code{TRUE}. Ignored if a custom
\code{deserialiser} is used.}

\item{environ}{environment in which to search for the function given by the
"_HANDLER" environment variable. Defaults to the parent frame.}
}
\description{
This function provides a configuration object that can be passed to
\code{\link{start_lambda}}. By default it will use the environment variables
configured by AWS Lambda and so will often work without arguments.

The most important configuration variable is the handler function which
processes invocations of the Lambda. This is configured in any of the three
below ways, in order of decreasing priority:
\enumerate{
\item configured directly through the AWS Lambda console
\item configured as the \code{CMD} argument of the Docker container holding the
runtime
\item passed as a value to the \code{handler} argument of \code{lambda_config}
}

In the first two options, the handler will be made available to the runtime
through the "_HANDLER" environment variable. This function will search for
the function in the given \code{environ}ment.

If the handler accepts a \code{context} argument then it will receive a list of
suitable event context for every invocation. This argument must be named
(\code{...} will not work), and the configuration may be different for each
invocation type. See the section below for more details.
}
\details{
As a rule of thumb, it takes longer to retrieve a value from an environment
variable than it does to retrieve a value from R. This is because retrieving
an environment variable requires a system call. Since the environment
variables do not change in a Lambda instance, we fetch them once and store
them in a configuration object which is passed to the various internal
functions.
}
\section{AWS Lambda variables}{


The \code{\link{lambda_config}} function obtains the configuration values
for the Lambda runtime configures the R session for Lambda based on
environment variables made available by Lambda. The following environment
variables are available:
\itemize{
\item Lambda Runtime API, available as the "AWS_LAMBDA_RUNTIME_API" environment
variable, is the host of the various HTTP endpoints through which the
runtime interacts with Lambda.
\item Lambda Task Root, available as the "LAMBDA_TASK_ROOT" environment variable,
defines the path to the Lambda function code. It isn't used in container
environments with a custom runtime, as that runtime is responsible for
finding and sourcing the function code. Hence, a missing task root is
ignored by this package.
\item The handler, available as the "_HANDLER" environment variable, is
interpreted by R as the function that is executed when the Lambda is
called. This value could be anything, as the interpretation is solely up
to the runtime, so requiring it to be a function is a standard imposed by
this package.
}

These \code{handler}, \code{runtime_api} and \code{task_root} arguments to the
\code{\link{lambda_config}} function can also provide values to these
configuration options, although the environment variables will always be
used if available. While it may be sensible to provide the \code{handler}
function directly, the other two configuration options are only provided for
debugging and testing purposes.
}

\section{Event context}{

Context is metadata associated with each invocation. If the handler function
accepts a \code{context} argument then it will automatically receive at runtime a
named list consisting of these values along with the arguments in the body
(if any). For example, a function such as \code{my_func(x, context)} will receive
the context argument automatically. The \code{context} argument must be named
(\code{...} will not work).

Refer to \code{vignette("lambda-runtime-in-container", package = "lambdr")}
for details.
}

