% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle-event.R
\name{handle_event}
\alias{handle_event}
\title{Process the input of an event, and submit the result to Lambda}
\usage{
handle_event(event, config = lambda_config())
}
\arguments{
\item{event}{the response received from querying the next invocation
endpoint.}

\item{config}{A list of configuration values as created by the
\code{lambda_config} function.}
}
\description{
If the handler function accepts a named \code{context} argument then the Lambda
invocation context will be included as an argument. See the section below for
more details.
}
\section{Invocations via an API Gateway}{

Events coming from an API Gateway need to be treated a little differently,
both in parsing the event content and in posting the results. Refer to
\code{vignette("api-gateway-invocations", package = "lambdr")} for details.
}

\section{Event context}{

Context is metadata associated with each invocation. If the handler function
accepts a \code{context} argument then it will automatically receive at runtime a
named list consisting of these values along with the arguments in the body
(if any). For example, a function such as \code{my_func(x, context)} will receive
the context argument automatically. The \code{context} argument must be named
(\code{...} will not work).

Refer to \code{vignette("lambda-runtime-in-container", package = "lambdr")}
for details.
}

\keyword{internal}
