% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_cpland.R
\name{lsm_c_cpland}
\alias{lsm_c_cpland}
\title{CPLAND (class level)}
\usage{
lsm_c_cpland(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Core area percentage of landscape (Core area metric)
}
\details{
\deqn{CPLAND = (\frac{\sum \limits_{j = 1}^{n} a_{ij}^{core}} {A}) * 100}
where \eqn{a_{ij}^{core}} is the core area in square meters and \eqn{A}
is the total landscape area in square meters.

CPLAND is a 'Core area metric'. It is the percentage of core area of class i in relation to
the total landscape area. A cell is defined as core area if the cell has
no neighbour with a different value than itself (rook's case). Because CPLAND is
a relative measure, it is comparable among landscapes with different total areas.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{Percentage}
\subsection{Range}{0 <= CPLAND < 100}
\subsection{Behaviour}{Approaches CPLAND = 0 if CORE = 0 for all patches. Increases as
the amount of core area increases, i.e. patches become larger while being rather simple
in shape.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_cpland(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_p_core}} and \code{\link{lsm_l_ta}}
}
