% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/langevitour.R
\name{langevitour-shiny}
\alias{langevitour-shiny}
\alias{langevitourOutput}
\alias{renderLangevitour}
\title{Shiny bindings for langevitour}
\usage{
langevitourOutput(outputId, width = "100\%", height = "600px")

renderLangevitour(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a langevitour, usually a block of code ending with a call to \code{langevitour()}}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using langevitour within Shiny
applications and interactive Rmd documents.
}
\examples{

library(shiny)
library(palmerpenguins)

completePenguins <- na.omit(penguins[,c(1,3,4,5,6)])
scale <- apply(completePenguins[,-1], 2, sd)*4

ui <- fluidPage(
    sliderInput('zoom', 'Zoom', 0, min=-1, max=1, step=0.1),
    langevitourOutput('widget')
)

server <- function(input,output) { 
    output$widget <- renderLangevitour({
        langevitour(
            completePenguins[,-1], 
            completePenguins$species, 
            scale=scale * 10^input$zoom, pointSize=2)
    })
}

app <- shinyApp(ui, server)

# Use runApp(app) or runGadget(app) to run app.

}
