% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{calculate_abundances}
\alias{calculate_abundances}
\title{Calculate isotope fractional abundances}
\usage{
calculate_abundances(data, ..., name_fun = default_name, quiet = F)
}
\arguments{
\item{data}{a data frame with raw ion counts retrieved from \code{\link{load_LANS_summary}}}

\item{...}{the fractional abundances to calculate, each entry is for one fractional abundance with major isotope first, then
minor isotope, e.g. c(`13C`, `12C`), c(`15N12C`, `14C12C`), ...}

\item{name_fun}{the naming function, receives ... from the top level, default concatenates 'F' + minor ion name}

\item{quiet}{whether the function should output information messages or be quiet (default is to output)}
}
\value{
the original data frame with the fractional abundance information appended (all fractional abundances are in % and have data_type == "abundance")
}
\description{
This function calculates the isotope abundances (in %!) and resulting counting
statistics error from the raw ion counts. It can be applied to data from both
LANS_summary and LANS_maps loading but can be slow if LANS_maps is combined
from many analyses.
}
\seealso{
Other calculations: \code{\link{calculate_ratios}},
  \code{\link{calculate_sums}}, \code{\link{calculate}}
}
