% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{freqs}
\alias{freqs}
\title{Frequencies Calculations and Plot}
\usage{
freqs(
  df,
  ...,
  wt = NULL,
  rel = FALSE,
  results = TRUE,
  variable_name = NA,
  plot = FALSE,
  rm.na = FALSE,
  title = NA,
  subtitle = NA,
  top = 20,
  abc = FALSE,
  save = FALSE,
  subdir = NA
)
}
\arguments{
\item{df}{Data.frame}

\item{...}{Variables. Variables you wish to process. Order matters.
If no variables are passed, the whole data.frame will be considered}

\item{wt}{Variable, numeric. Weights.}

\item{rel}{Boolean. Relative percentages (or absolute)?}

\item{results}{Boolean. Return results in a dataframe?}

\item{variable_name}{Character. Overwrite the main variable's name}

\item{plot}{Boolean. Do you want to see a plot? Three variables tops.}

\item{rm.na}{Boolean. Remove NA values in the plot? (not filtered for
numerical output; use na.omit() or filter() if needed)}

\item{title}{Character. Overwrite plot's title with.}

\item{subtitle}{Character. Overwrite plot's subtitle with.}

\item{top}{Integer. Filter and plot the most n frequent for
categorical values. Set to NA to return all values}

\item{abc}{Boolean. Do you wish to sort by alphabetical order?}

\item{save}{Boolean. Save the output plot in our working directory}

\item{subdir}{Character. Into which subdirectory do you wish to
save the plot to?}
}
\value{
Plot when \code{plot=TRUE} and data.frame with grouped frequency results
when \code{plot=FALSE}.
}
\description{
This function lets the user group, count, calculate percentages
and cumulatives. It also plots results if needed. Tidyverse friendly.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dft) # Titanic dataset

# How many survived?
dft \%>\% freqs(Survived)

# How many survived per Class?
dft \%>\% freqs(Pclass, Survived, abc = TRUE)

# How many survived per Class with relative percentages?
dft \%>\% freqs(Pclass, Survived, abc = TRUE, rel = TRUE)

# Using a weighted feature
dft \%>\% freqs(Pclass, Survived, wt = Fare / 100)

# Let's check the results with plots:

#' # How many survived and see plot?
dft \%>\% freqs(Survived, plot = TRUE)

# How many survived per class?
dft \%>\% freqs(Survived, Pclass, plot = TRUE)

# Per class, how many survived?
dft \%>\% freqs(Pclass, Survived, plot = TRUE)

# Per sex and class, how many survived?
dft \%>\% freqs(Sex, Pclass, Survived, plot = TRUE)

# Frequency of tickets + Survived
dft \%>\% freqs(Survived, Ticket, plot = TRUE)

# Frequency of tickets: top 10 only and order them alphabetically
dft \%>\% freqs(Ticket, plot = TRUE, top = 10, abc = TRUE)
}
\seealso{
Other Frequency: 
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()}

Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{lasso_vars}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()},
\code{\link{trendsRelated}()}

Other Visualization: 
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{gg_bars}()},
\code{\link{noPlot}()},
\code{\link{plot_chord}()},
\code{\link{plot_survey}()},
\code{\link{plot_timeline}()},
\code{\link{theme_lares}()},
\code{\link{tree_var}()}
}
\concept{Exploratory}
\concept{Frequency}
\concept{Visualization}
