% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_plots.R
\name{gg_bars}
\alias{gg_bars}
\title{Quick Nice Bar Plot}
\usage{
gg_bars(
  names,
  n,
  p = NA,
  title = NA,
  subtitle = NA,
  axis = "Counter",
  obs = TRUE,
  limit = 15,
  na.rm = FALSE
)
}
\arguments{
\item{names}{Character Vector. Bar names}

\item{n, p}{Numeric Vectors. n for counter, p to force percentage.}

\item{title, subtitle, axis}{Character. Texts for plot}

\item{obs}{Boolean. Show observations counter?}

\item{limit}{Integer. Limit n most frequent values only}

\item{na.rm}{Boolean. Remove empty and NAs?}
}
\value{
ggplot2 object
}
\description{
This function uses a nice template for barplots.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dft) # Titanic dataset
df <- freqs(dft, Pclass)
gg_bars(df$Pclass, n = df$n)
gg_bars(df$Pclass, n = df$n, p = df$p, axis = "Percentage of ...")
}
\seealso{
Other Visualization: 
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{noPlot}()},
\code{\link{plot_chord}()},
\code{\link{plot_survey}()},
\code{\link{plot_timeline}()},
\code{\link{theme_lares}()},
\code{\link{tree_var}()}
}
\concept{Visualization}
