% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{stocks_quote}
\alias{stocks_quote}
\alias{stocks_hist}
\alias{plot.stocks_hist}
\title{Download Stocks Historical and Current Values}
\usage{
stocks_quote(symbols, ...)

stocks_hist(
  symbols = c("VTI", "META"),
  from = Sys.Date() - 365,
  to = Sys.Date(),
  today = TRUE,
  tax = 15,
  parg = FALSE,
  cache = TRUE,
  quiet = FALSE,
  ...
)

\method{plot}{stocks_hist}(x, type = 1, ...)
}
\arguments{
\item{symbols}{Character Vector. List of symbols to download historical data.}

\item{...}{Additional parameters.}

\item{from, to}{Date. Dates for range. If not set, 1 year will be downloaded.
Do use more than 4 days or will be over-written.}

\item{today}{Boolean. Do you wish to add today's live quote? This will happen
only if to value is the same as today's date}

\item{tax}{Numeric. How much [0-99] of your dividends are gone with taxes?}

\item{parg}{Boolean. Personal argument. Used to personalize stuff, in this
case, taxes changed from A to B in given date (hard-coded)}

\item{cache}{Boolean. Use daily cache if available?}

\item{quiet}{Boolean. Keep quiet? If not, message will be shown.}

\item{x}{stocks_hist object}

\item{type}{Integer. Select type of plot.}
}
\value{
data.frame with Symbol, Type of stock, Quote time, current value,
Daily Change, Market, and Symbol Name.
}
\description{
This function lets the user download stocks live data.

This function lets the user download stocks historical data.
}
\examples{
\donttest{
# Multiple quotes at the same time
stocks_quote(c("VTI", "VOO", "TSLA"))
}
\dontrun{
df <- stocks_hist(symbols = c("VTI", "META", "FIW"), from = Sys.Date() - 180)
print(head(df))
plot(df)
}
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_divs}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_report}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{gtrends_related}()},
\code{\link{holidays}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()}
}
\concept{Investment}
\concept{Scrapper}
