% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/png.R
\name{tex2png}
\alias{tex2png}
\title{Convert TEX to PNG}
\usage{
tex2png(x, stem = NULL, dir = NULL, clean = TRUE, onefile = FALSE,
  replace = TRUE, ...)
}
\arguments{
\item{x}{vector of file names}

\item{stem}{the stem of a file name (no extension)}

\item{dir}{output directory}

\item{clean}{whether to delete system files after PNG creation}

\item{onefile}{whether to combine tex snippets into a single file}

\item{replace}{whether to delete the intermediate PDF files}

\item{...}{passed to \code{\link{tex2pdf}} and \code{\link{ghostconvert}}}
}
\description{
Converts TEX to PNG.  \code{tex2png} accepts the file names of TEX fragments. It reads those fragments, wraps them like documents and makes PNG files (converted from PDF files).
}
\examples{
\dontrun{
file <- file.path(tempdir(),'test.tex')
writeLines(as.ltable(head(Theoph)), file)
tex2png(file, gs_cmd = 'mgs')
}
}
\seealso{
\code{\link{as.png.character}}

\code{\link{viewtex}}
}
