% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/zzz.R
\name{latrend-generics}
\alias{latrend-generics}
\title{Method- and model-specific generics defined by the latrend package}
\usage{
trajectoryAssignments(object, ...)

clusterProportions(object, ...)

clusterTrajectories(object, ...)

compose(method, envir, ...)

converged(object, ...)

externalMetric(object, object2, name, ...)

fit(method, data, envir, verbose, ...)

getLabel(object, ...)

getName(object, ...)

getShortName(object, ...)

idVariable(object, ...)

metric(object, name, ...)

plotClusterTrajectories(object, ...)

qqPlot(object, ...)

plotTrajectories(object, ...)

postprob(object, ...)

predictAssignments(object, newdata = NULL, ...)

predictForCluster(object, newdata = NULL, cluster, ...)

predictPostprob(object, newdata = NULL, ...)

postFit(method, data, model, envir, verbose, ...)

preFit(method, data, envir, verbose, ...)

prepareData(method, data, verbose, ...)

responseVariable(object, ...)

strip(object, ...)

timeVariable(object, ...)

validate(method, data, envir, ...)
}
\arguments{
\item{object}{The object.}

\item{...}{Arguments.}

\item{method}{The method.}

\item{envir}{\code{environment}.}

\item{object2}{The model to compare with.}

\item{name}{Metric name.}

\item{data}{\code{data.frame}.}

\item{verbose}{\link[R.utils:Verbose]{R.utils::Verbose}.}

\item{newdata}{\code{data.frame} of newdata.}

\item{cluster}{Cluster name.}

\item{what}{Parameter.}
}
\value{
The stripped (i.e., updated) object.
}
\description{
List of S4 generic methods which have no general use other than supporting
functions with signatures of \code{lcMethod} or \code{lcModel}.

Reduce the (serialized) memory footprint of an object.
}
\details{
Serializing references to environments results in the serialization of the object
together with any associated environments and references. This method removes those environments
and references, greatly reducing the serialized object size.
}
\keyword{internal}
