% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latrend.R
\name{latrendRep}
\alias{latrendRep}
\title{Cluster longitudinal data repeatedly}
\usage{
latrendRep(
  method,
  data,
  .rep = 10,
  ...,
  .errorhandling = "remove",
  .seed = NULL,
  envir = NULL,
  verbose = getOption("latrend.verbose")
)
}
\arguments{
\item{method}{The \code{lcMethod} object specifying the longitudinal cluster method to apply.}

\item{data}{The \code{data.frame} or \code{matrix} to which to apply the method.}

\item{.rep}{The number of repeated fits.}

\item{...}{Any other arguments to update the \code{lcMethod} definition with.}

\item{.errorhandling}{How to handle fits in which on error occurs.
If \code{"remove"}, errors are ignored and the respective repetition is exempt from the returned model list.
If \code{"stop"}, errors are not caught, ensuring that the function halts on the first error.}

\item{.seed}{Set the seed for generating the respective seed for each of the repeated fits.}

\item{envir}{The \code{environment} in which to evaluate the method arguments. Note that this only applies to \code{data} when \code{data} is a \code{call}.}

\item{verbose}{The level of verbosity. Either an object of class \code{Verbose} (see \link[R.utils:Verbose]{R.utils::Verbose} for details),
a \code{logical} indicating whether to show basic computation information,
a \code{numeric} indicating the verbosity level (see \link{Verbose}),
or one of \code{c('info', 'fine', 'finest')}.}
}
\value{
A \code{lcModels} object containing the resulting models.
}
\description{
Performs a repeated fit of the specified latrend model on the given data.
}
\details{
This method is faster than repeatedly calling \link{latrend} as it only prepares the data via \code{prepareData()} once.
}
\examples{
data(latrendData)
method <- lcMethodKML("Y", id = "Id", time = "Time")
models <- latrendRep(method, data = latrendData, .rep = 5) # 5 repeated runs

models <- latrendRep(method, data = latrendData, .seed = 1, .rep = 3)
}
\seealso{
Other longitudinal cluster fit functions: 
\code{\link{latrendBatch}()},
\code{\link{latrendBoot}()},
\code{\link{latrendCV}()},
\code{\link{latrend}()}
}
\concept{longitudinal cluster fit functions}
