% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{prepareData}
\alias{prepareData}
\alias{prepareData,lcMethod-method}
\title{lcMethod fit process: logic for preparing the training data}
\usage{
\S4method{prepareData}{lcMethod}(method, data, verbose)
}
\arguments{
\item{method}{An object inheriting from \code{lcMethod} with all its arguments having been evaluated and finalized.}

\item{data}{A \code{data.frame} representing the transformed training data.}

\item{verbose}{A \link[R.utils:Verbose]{R.utils::Verbose} object indicating the level of verbosity.}
}
\value{
An \code{environment} with the prepared data variable(s) that will be passed to \code{\link[=preFit]{preFit()}}.
}
\description{
Note: this function should not be called directly, as it is part of the \code{lcMethod} fitting process. For fitting an \code{lcMethod} object to a dataset, see \code{\link[=latrend]{latrend()}}.

The \code{prepareData()} function of the \code{lcMethod} object processes the training data prior to fitting the method.
Example uses:
\itemize{
\item Transforming the data to another format, e.g., a matrix.
\item Truncating the response variable.
\item Computing derived covariates.
\item Creating additional data objects.
}
The computed variables are stored in an \code{environment} which is passed to the \code{\link[=preFit]{preFit()}} function for further processing.

By default, this method does not do anything.
}
\section{Implementation}{

A common use case for this method is when the internal method fitting procedure expects the data in a different format.
In this example, the method converts the training data \code{data.frame} to a \code{matrix} of repeated and aligned trajectory measurements.
\preformatted{
setMethod("prepareData", "lcMethodExample", function(method, data, verbose) {
  envir = new.env()
  # transform the data to matrix
  envir$dataMat = dcastRepeatedMeasures(data,
    id = idColumn, time = timeColumn, response = valueColumn)
  return(envir)
})
}
}

\section{Fitting procedure}{

Each \code{lcMethod} subclass defines a type of methods in terms of a series of steps for estimating the method.
These steps, as part of the fitting procedure, are executed by \code{\link[=latrend]{latrend()}} in the following order:
\enumerate{
\item \code{\link[=compose]{compose()}}: Evaluate and finalize the method argument values.
\item \code{\link[=validate]{validate()}}: Check the validity of the method argument values in relation to the dataset.
\item \code{\link[=prepareData]{prepareData()}}: Process the training data for fitting.
\item \code{\link[=preFit]{preFit()}}: Prepare environment for estimation, independent of training data.
\item \code{\link[=fit]{fit()}}: Estimate the specified method on the training data, outputting an object inheriting from \code{lcModel}.
\item \code{\link[=postFit]{postFit()}}: Post-process the outputted \code{lcModel} object.
}

The result of the fitting procedure is an \linkS4class{lcModel} object that inherits from the \code{lcModel} class.
}

