% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R, R/model.R
\name{strip}
\alias{strip}
\alias{strip,lcMethod-method}
\alias{strip,ANY-method}
\alias{strip,lcModel-method}
\title{Reduce the lcModel memory footprint for serialization}
\usage{
\S4method{strip}{lcMethod}(object, ..., classes = "formula")

\S4method{strip}{ANY}(object, ..., classes = "formula")

\S4method{strip}{lcModel}(object, ..., classes = "formula")
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{Additional arguments.}

\item{classes}{The object classes for which to remove their assigned environment. By default, only environments from \code{formula} are removed.}
}
\value{
An \code{lcModel} object of the same type as the \code{object} argument.
}
\description{
Strip a lcModel of non-essential variables and environments in order to reduce the model size for serialization.
}
\section{Implementation}{

Classes extending \code{lcModel} can override this method to remove additional non-essentials.
\preformatted{
setMethod("strip", "lcModelExt", function(object, ..., classes = "formula") {
  object <- callNextMethod()
  # further process the object
  return(object)
})
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)
newModel <- strip(model)
}
\seealso{
Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric,lcModel,lcModel-method}},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
