% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest.R
\name{lawn_nearest}
\alias{lawn_nearest}
\title{Get nearest point}
\usage{
lawn_nearest(point, against, lint = FALSE)
}
\arguments{
\item{point}{The reference point, a \link{data-Feature}<(\link{data-Point})>}

\item{against}{Input point set, a \link{data-FeatureCollection}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
A \link{data-Feature}<(\link{data-Point})>
}
\description{
Takes a reference \link{data-Point} and a set of points to compare it
against and returns the point from the set closest to the reference
}
\examples{
point <- '{
  "type": "Feature",
  "properties": {
    "marker-color": "#0f0"
  },
  "geometry": {
    "type": "Point",
    "coordinates": [28.965797, 41.010086]
  }
}'
against <- '{
 "type": "FeatureCollection",
 "features": [
   {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "Point",
       "coordinates": [28.973865, 41.011122]
     }
   }, {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "Point",
       "coordinates": [28.948459, 41.024204]
     }
   }, {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "Point",
       "coordinates": [28.938674, 41.013324]
     }
   }
 ]
}'
lawn_nearest(point, against)

\dontrun{
lawn_nearest(point, against) \%>\% view
}
}
