% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectionof.R
\name{lawn_collectionof}
\alias{lawn_collectionof}
\title{Enforce expectations about types of FeatureCollection inputs}
\usage{
lawn_collectionof(x, type, name, lint = FALSE)
}
\arguments{
\item{x}{a \link{data-FeatureCollection} for which features will be judged.
required}

\item{type}{(character) expected GeoJSON type. required.}

\item{name}{(character) name of calling function. required.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
nothing if no problems - error message if a problem
}
\description{
Enforce expectations about types of FeatureCollection inputs
}
\examples{
# all okay
cat(lawn_data$points_count)
lawn_collectionof(lawn_data$points_count, 'Point', 'stuff')

# error
# lawn_collectionof(lawn_data$points_count, 'Polygon', 'stuff')
}
\seealso{
Other invariant: \code{\link{lawn_featureof}},
  \code{\link{lawn_geosjontype}}
}
