% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrycollection.R
\name{lawn_geometrycollection}
\alias{lawn_geometrycollection}
\title{Create a geometrycollection}
\usage{
lawn_geometrycollection(coordinates, properties = NULL)
}
\arguments{
\item{coordinates}{A list of GeoJSON geometries, or in json.}

\item{properties}{A list of properties.}
}
\value{
A \link{data-GeometryCollection} feature.
}
\description{
Create a geometrycollection
}
\examples{
x <- list(
  list(
    type = "Point",
    coordinates = list(
     list(100, 0)
    )
  ),
  list(
    type = "LineString",
    coordinates = list(
     list(100, 0),
     list(102, 1)
    )
  )
)
lawn_geometrycollection(x)
lawn_geometrycollection(x,
  properties = list(city = 'Los Angeles', population = 400))

x <- '[
   {
     "type": "Point",
     "coordinates": [100.0, 0.0]
   },
   {
     "type": "LineString",
     "coordinates": [ [101.0, 0.0], [102.0, 1.0] ]
   }
]'
lawn_geometrycollection(x)
}
\seealso{
Other data functions: 
\code{\link{lawn_featurecollection}()},
\code{\link{lawn_feature}()},
\code{\link{lawn_filter}()},
\code{\link{lawn_linestring}()},
\code{\link{lawn_multilinestring}()},
\code{\link{lawn_multipoint}()},
\code{\link{lawn_multipolygon}()},
\code{\link{lawn_point}()},
\code{\link{lawn_polygon}()},
\code{\link{lawn_random}()},
\code{\link{lawn_remove}()},
\code{\link{lawn_sample}()}
}
\concept{data functions}
