% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_transposed_data.R
\name{create_transposed_data}
\alias{create_transposed_data}
\title{Create Transposed Data}
\usage{
create_transposed_data(x, n = 50)
}
\arguments{
\item{x}{- data set containing a table where 1st column is a Time index and other columns containing financial asset indicator values}

\item{n}{- number of rows we intend to split and transpose the data}
}
\value{
function returns transposed data. Transposed values from every column are stacked one to each other
}
\description{
PURPOSE: function gets indicator data in each column.
Goal is to splitting this data into periods and transpose the data.

Learn by example how to manipulate data
}
\details{
each column contains records of the indicator value of the assets
every column will be split into chunks of n observations and transposed into rows
this repeated for all the columns coming up with a matrix.
Function works in combination with a function create_labelled_data
}
\examples{


library(tidyverse)

# usind a sample data
data(indicator_dataset)

create_transposed_data(indicator_dataset, n = 75)



}
