% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_profit_factorDF.R
\name{get_profit_factorDF}
\alias{get_profit_factorDF}
\title{Function that returns the profit factors of the systems in a form of a DataFrame}
\usage{
get_profit_factorDF(x, num_orders)
}
\arguments{
\item{x}{\itemize{
\item data frame with orders. Note x must contain MagicNumber and Profit columns!
}}

\item{num_orders}{\itemize{
\item desired number of orders to base profit factor calculation
}}
}
\value{
\itemize{
\item Function returns dataframe with column PrFact with calculated profit factor value for each trading robot
}
}
\description{
Calculation of profit factor using dplyr verbs

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
}
\examples{

library(lazytrade)
library(dplyr)
library(magrittr)
data(profit_factorDF)
get_profit_factorDF(x = profit_factorDF,
                    num_orders = 10)



}
