% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{dliouvm}
\alias{dliouvm}
\title{Marginal density function for Liouville copulas}
\usage{
dliouvm(x, family, alpha, theta)
}
\arguments{
\item{x}{sample vector from a Liouville copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alpha}{allocation parameter (must be an integer)}

\item{theta}{parameter of the corresponding Archimedean copula}
}
\value{
value of marginal density
}
\description{
The function is using the telescoping series property - that is, it computes only the last derivative.
}
\examples{
samp <- rliouv(n = 100, family = "clayton", alphavec <- c(2,3), theta = 2)
dliouvm(x=samp[,1], family="clayton", alpha=2, theta=2)
sum(log(dliouvm(x=samp[,1], family="clayton", alpha=2, theta=2)))
}

