% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{isliouvm}
\alias{isliouvm}
\title{Marginal inverse survival function for Liouville copulas}
\usage{
isliouvm(u, family, alpha, theta)
}
\arguments{
\item{u}{vector of survival probabilities}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alpha}{marginal allocation parameter (must be integer)}

\item{theta}{parameter of the corresponding Archimedean copula}
}
\value{
a vector of same length as \code{u} with the quantile at \code{1-u}
}
\description{
Survival analog to \code{'q'} in R for functions
}
\examples{
u <- rliouv(n = 100, family = "clayton", alphavec <- c(2,3), theta = 2)
isliouvm(u=u[,1], family="clayton", alpha=2, theta=2)
}

