% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawOptions.R
\name{toolbarOptions}
\alias{toolbarOptions}
\title{Options for editing the toolbar}
\usage{
toolbarOptions(
  actions = list(title = "Cancel drawing", text = "Cancel"),
  finish = list(title = "Finish drawing", text = "Finish"),
  undo = list(title = "Delete last point drawn", text = "Delete last point"),
  buttons = list(polyline = "Draw a polyline", polygon = "Draw a polygon", rectangle =
    "Draw a rectangle", circle = "Draw a circle", marker = "Draw a marker", circlemarker
    = "Draw a circlemarker")
)
}
\arguments{
\item{actions}{List of options for actions toolbar button.}

\item{finish}{List of options for finish toolbar button.}

\item{undo}{List of options for undo toolbar button.}

\item{buttons}{List of options for buttons toolbar button.}
}
\description{
Customize the toolbar for \code{\link{addDrawToolbar}}
}
\examples{
\dontrun{
library(leaflet)
library(leaflet.extras)
leaflet() \%>\%
  addTiles() \%>\%
  addDrawToolbar(
    toolbar = toolbarOptions(
      actions = list(text = "STOP"),
      finish = list(text = "DONE"),
      buttons = list(
        polyline = "Draw a sexy polyline",
        rectangle = "Draw a gigantic rectangle",
        circlemarker = "Make a nice circle"
      ),
    ),
    polylineOptions = T, rectangleOptions = T, circleOptions = T,
    polygonOptions = F, markerOptions = F, circleMarkerOptions = F
  )
}
}
