% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPopupImages.R
\name{addPopupImages}
\alias{addPopupImages}
\title{Add image popups to leaflet layers.}
\usage{
addPopupImages(map, image, group, width = NULL, height = NULL)
}
\arguments{
\item{map}{the \code{leaflet} map to add the popups to.}

\item{image}{A character \code{vector} of file path(s) or
web-URL(s) to any sort of image file(s).}

\item{group}{the map group to which the popups should be added.}

\item{width}{the width of the image(s) in pixels.}

\item{height}{the height of the image(s) in pixels.}
}
\value{
A \code{leaflet} map.
}
\description{
Add image popups to leaflet layers.
}
\examples{
if (interactive()) {
## remote images -----
### one image
library(leaflet)
library(sf)

pnt = st_as_sf(data.frame(x = 174.764474, y = -36.877245),
                coords = c("x", "y"),
                crs = 4326)

img = "http://bit.ly/1TVwRiR"

leaflet() \%>\%
  addTiles() \%>\%
  addCircleMarkers(data = pnt, group = "pnt") \%>\%
  addPopupImages(img, group = "pnt")

### multiple file (types)
library(sf)
images = c(img,
            "https://upload.wikimedia.org/wikipedia/commons/9/91/Octicons-mark-github.svg",
            "https://www.r-project.org/logo/Rlogo.png",
            "https://upload.wikimedia.org/wikipedia/commons/d/d6/MeanMonthlyP.gif")

pt4 = data.frame(x = jitter(rep(174.764474, 4), factor = 0.01),
                  y = jitter(rep(-36.877245, 4), factor = 0.01))
pt4 = st_as_sf(pt4, coords = c("x", "y"), crs = 4326)

leaflet() \%>\%
  addTiles() \%>\%
  addMarkers(data = pt4, group = "points") \%>\%
  addPopupImages(images, group = "points", width = 400) # NOTE the gif animation

## local images -----
pnt = st_as_sf(data.frame(x = 174.764474, y = -36.877245),
                coords = c("x", "y"), crs = 4326)
img = system.file("img","Rlogo.png",package="png")
leaflet() \%>\%
  addTiles() \%>\%
  addCircleMarkers(data = pnt, group = "pnt") \%>\%
  addPopupImages(img, group = "pnt")
}

}
