% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_models.R
\name{unit_midpoint}
\alias{unit_midpoint}
\title{Midpoint Unit Function}
\usage{
unit_midpoint(m, n, r, na.rm = FALSE)
}
\arguments{
\item{m}{lower bound unit of production}

\item{n}{upper bound unit of production}

\item{r}{learning curve rate}

\item{na.rm}{Should \code{NA} values be removed?}
}
\description{
Provides the so-called "midpoint" or average unit between units m and n (where n > m). Based on Crawford's unit learning curve model.
}
\examples{
# If a production block runs from unit 201 to unit 500 inclusive
# with a 75\% learning curve, what is the midpoint unit?

unit_midpoint(m = 201, n = 500, r = .75)
## [1] 334.6103

}
