% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_cs.R
\name{crop_cs}
\alias{crop_cs}
\title{Crop Cost Surface}
\usage{
crop_cs(cost_surface, boundary)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} (gdistance package). Cost surface to crop}

\item{boundary}{\code{SpatialPolygons*} (sp package). Boundary used when cropping Cost Surface}
}
\value{
\code{TransitionLayer} (gdistance package). Cropped Cost Surface
}
\description{
Crops Cost Surfaces to the supplied SpatialPolygon* boundary
}
\details{
The resultant Cost Surface is cropped to the SpatialPolygons* boundary. All areas of the Cost Surface that are outside the supplied boundary are given a conductance value of 0. The conductance value of 0 ensures that movement is inhibited within these areas.
}
\examples{
r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))
loc1 = cbind(2667670, 6479000)
loc1 = sp::SpatialPoints(loc1)
loc1 <- rgeos::gBuffer(spgeom = loc1, width = 200)
raster::crs(loc1) <- raster::crs(r)

slope_cs <- create_slope_cs(r, cost_function = 'tobler', neighbours = 16, max_slope = NULL)

slope_cs_cropped <- crop_cs(cost_surface = slope_cs, boundary = loc1)
}
\author{
Joseph Lewis
}
