% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.r
\name{register}
\alias{register}
\title{Import a hledger or beancount register}
\usage{
register(file, flags = NULL, toolchain = default_toolchain(file))
}
\arguments{
\item{file}{Filename for a ledger, hledger, or beancount file.}

\item{flags}{Character vector of additional command line flags to pass 
to either \code{ledger csv} or \code{hledger register}.}

\item{toolchain}{Toolchain used to read in register. 
Either "ledger", "hledger", "bean-report_ledger", or "bean-report_hledger".}
}
\value{
\code{register} returns a data frame.
}
\description{
\code{register} imports the register from a ledger, hledger, or beancount file as a data frame.
}
\examples{
   \dontrun{
     example_beancount_file <- system.file("extdata", "example.beancount", package = "ledger") 
     dfb <- register(example_beancount_file)
     head(df)   

     dfb2 <- rio::import(example_beancount_file)
     all.equal(dfb, dfb2)

     example_hledger_file <- system.file("extdata", "example.hledger", package = "ledger") 
     dfh <- register(example_hledger_file)
     head(dfh)

     example_ledger_file <- system.file("extdata", "example.ledger", package = "ledger") 
     dfl <- register(example_ledger_file)
     head(dfl)
   }
}
