% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializeSEM.R
\name{.extractSEMFromLavaan}
\alias{.extractSEMFromLavaan}
\title{.extractSEMFromLavaan}
\usage{
.extractSEMFromLavaan(
  lavaanModel,
  whichPars = "est",
  fit = TRUE,
  addMeans = TRUE,
  activeSet = NULL,
  dataSet = NULL,
  transformations = NULL
)
}
\arguments{
\item{lavaanModel}{model of class lavaan}

\item{whichPars}{which parameters should be used to initialize the model. If set to "est", the parameters will be set to the
estimated parameters of the lavaan model. If set to "start", the starting values of lavaan will be used. The latter can be useful if parameters are to
be optimized afterwards as setting the parameters to "est" may result in the model getting stuck in a local minimum.}

\item{fit}{should the model be fitted and compared to the lavaanModel?}

\item{addMeans}{If lavaanModel has meanstructure = FALSE, addMeans = TRUE will add a mean structure. FALSE will set the means of the observed variables to the average}

\item{activeSet}{Option to only use a subset of the individuals in the data set. Logical vector of length N indicating which subjects should remain in the sample.}

\item{dataSet}{optional: Pass an alternative data set to lessSEM:::.SEMFromLavaan which will replace the original data set in lavaanModel.}

\item{transformations}{optional: transform parameter values.}
}
\value{
list with SEMList (model in RAM representation) and fit (boolean indicating if the model should
be fit and compared to lavaan)
}
\description{
internal function. Translates an object of class lavaan to the internal model representation.
}
\keyword{internal}
