% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consequents.R
\name{consequents}
\alias{consequents}
\title{Extract consequent-part (right-hand side) of rules in a list}
\usage{
consequents(rules)
}
\arguments{
\item{rules}{Either a list of character vectors or an object of class \code{\link[=farules]{farules()}}.}
}
\value{
A list of character vectors.
}
\description{
Given a list of rules or an instance of the S3 \code{\link[=farules]{farules()}} class,
the function returns a list of their consequents (i.e.
right-hand side of rules).
}
\details{
This function assumes \code{rules} to be a valid \code{\link[=farules]{farules()}} object or
a list of character vectors where
the first element of each vector is a consequent part and the
rest is an antecedent part of rules. Function returns a list of
consequents.
}
\examples{
    rules <- list(c('a', 'b', 'c'), c('d'), c('a', 'e'))
    consequents(rules)
    unlist(consequents(rules))   # as vector
}
\seealso{
\code{\link[=antecedents]{antecedents()}}, \code{\link[=farules]{farules()}}, \code{\link[=searchrules]{searchrules()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
