% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-plot.R
\name{plot_api_c}
\alias{plot_api_c}
\title{Plot a generated/fit model component}
\usage{
plot_api_c(
  df,
  df_err = NULL,
  alpha = 1,
  alpha_err = 0.2,
  no_err = FALSE,
  no_line = FALSE
)
}
\arguments{
\item{df}{a data frame}

\item{df_err}{a data frame}

\item{alpha}{line opacity}

\item{alpha_err}{ribbon opacity}

\item{no_err}{hide error bar even when it would normally be plotted?}

\item{no_line}{hide line even when it would normally be plotted?}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Data frames specified in arguments \code{df},
and \code{df_err} must have a format where
\itemize{
  \item The first column is the grouping factor (usually id).
  \item The second column is the x-axis variable (usually age).
  \item The third column is the coloring factor. If name of the third
  column is \code{NA}, coloring is not done.
  \item A column named \code{y} must contain the y-axis variable
  (not for \code{df_err}).
  \item A column named \code{lower} (\code{upper}) must contain the lower
  (upper) bound of error bar (only for \code{df_err}).
  \item The posterior draw using which the fit has been computed can be
  specified with a factor named \code{_draw_} (only for \code{df}).
}
}
\seealso{
Other internal plot API functions: 
\code{\link{plot_api_g}()}
}
\concept{internal plot API functions}
