% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppenderSyslog.R
\name{AppenderSyslog}
\alias{AppenderSyslog}
\title{Log to the POSIX system log}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Appender]{lgr::Appender} and can be uses as an appender by a \link[lgr:Logger]{lgr::Logger}.
}
\description{
An Appender that writes to the syslog on supported POSIX platforms. Requires
the \pkg{rsyslog} package.
}
\examples{
if (requireNamespace("rsyslog", quietly = TRUE) && Sys.info()[["sysname"]] == "Linux") {
  lg <- lgr::get_logger("rsyslog/test")
  lg$add_appender(AppenderSyslog$new(), "syslog")
  lg$info("A test message")
  print(system("journalctl -t 'rsyslog/test'"))

  invisible(lg$config(NULL))  # cleanup
}
}
\seealso{
\link[lgr:LayoutFormat]{lgr::LayoutFormat}, \link[lgr:LayoutGlue]{lgr::LayoutGlue}

Other Appenders: 
\code{\link{AppenderDbi}},
\code{\link{AppenderDt}},
\code{\link{AppenderElasticSearch}},
\code{\link{AppenderGmail}},
\code{\link{AppenderPushbullet}},
\code{\link{AppenderSendmail}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{AppenderSyslog}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{syslog_levels.}}{Either a named \code{character} vector or a \code{function}
mapping lgr \link[lgr:get_log_levels]{lgr::log_levels} to rsyslog log levels. See
\verb{$set_syslog_levels()}.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{identifier}}{\code{character} scalar. A string identifying the process;
if \code{NULL} defaults to the logger name}

\item{\code{syslog_levels.}}{Either a named \code{character} vector or a \code{function}
mapping lgr \link[lgr:get_log_levels]{lgr::log_levels} to rsyslog log levels. See
\verb{$set_syslog_levels()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AppenderSyslog-new}{\code{AppenderSyslog$new()}}
\item \href{#method-AppenderSyslog-append}{\code{AppenderSyslog$append()}}
\item \href{#method-AppenderSyslog-set_syslog_levels}{\code{AppenderSyslog$set_syslog_levels()}}
\item \href{#method-AppenderSyslog-set_identifier}{\code{AppenderSyslog$set_identifier()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="format"><a href='../../lgr/html/Appender.html#method-Appender-format'><code>lgr::Appender$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout"><a href='../../lgr/html/Appender.html#method-Appender-set_layout'><code>lgr::Appender$set_layout()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold"><a href='../../lgr/html/Appender.html#method-Appender-set_threshold'><code>lgr::Appender$set_threshold()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderSyslog-new"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderSyslog-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderSyslog$new(
  identifier = NULL,
  threshold = NA_integer_,
  layout = LayoutFormat$new("\%m"),
  filters = NULL,
  syslog_levels = c(CRITICAL = "fatal", ERR = "error", WARNING = "warn", INFO = "info",
    DEBUG = "debug", DEBUG = "trace")
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderSyslog-append"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderSyslog-append}{}}}
\subsection{Method \code{append()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderSyslog$append(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderSyslog-set_syslog_levels"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderSyslog-set_syslog_levels}{}}}
\subsection{Method \code{set_syslog_levels()}}{
Define conversion between lgr and syslog log levels
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderSyslog$set_syslog_levels(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\itemize{
\item a named \code{character} vector mapping whose names are log
levels as understood by \code{\link[rsyslog:syslog]{rsyslog::syslog()}} and whose values are \link[lgr:get_log_levels]{lgr log levels} (either \code{character} or \code{numeric})
\item a \code{function} that takes a vector of lgr log levels as input and
returns a \code{character} vector of log levels for \code{\link[rsyslog:syslog]{rsyslog::syslog()}}.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderSyslog-set_identifier"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderSyslog-set_identifier}{}}}
\subsection{Method \code{set_identifier()}}{
Set a string to identify the process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderSyslog$set_identifier(x)}\if{html}{\out{</div>}}
}

}
}
