/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/Message.h>
#include <so/private/Message.h>

so_Message *so_Message_new()
{
	so_Message *object = calloc(sizeof(so_Message), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_Message *so_Message_copy(so_Message *self)
{
	so_Message *dest = so_Message_new();
	if (dest) {
		if (self->type) {
			dest->type = pharmml_strdup(self->type);
			if (!dest->type) {
				so_Message_free(dest);
				return NULL;
			}
		}
		if (self->Toolname) {
			dest->Toolname = pharmml_strdup(self->Toolname);
			if (!dest->Toolname) {
				so_Message_free(dest);
				return NULL;
			}
		}
		if (self->Name) {
			dest->Name = pharmml_strdup(self->Name);
			if (!dest->Name) {
				so_Message_free(dest);
				return NULL;
			}
		}
		if (self->Content) {
			dest->Content = pharmml_strdup(self->Content);
			if (!dest->Content) {
				so_Message_free(dest);
				return NULL;
			}
		}
		if (self->Severity) {
			dest->Severity_number = self->Severity_number;
			dest->Severity = &(dest->Severity_number);
		}
	}

	return dest;
}

void so_Message_free(so_Message *self)
{
	if (self) {
		free(self->Toolname);
		free(self->Name);
		free(self->Content);
		if (self->type) free(self->type);
		free(self);
	}
}

void so_Message_ref(so_Message *self)
{
	self->reference_count++;
}

void so_Message_unref(so_Message *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_Message_free(self);
		}
	}
}

char *so_Message_get_type(so_Message *self)
{
	return self->type;
}

char *so_Message_get_Toolname(so_Message *self)
{
	return self->Toolname;
}

char *so_Message_get_Name(so_Message *self)
{
	return self->Name;
}

char *so_Message_get_Content(so_Message *self)
{
	return self->Content;
}

int *so_Message_get_Severity(so_Message *self)
{
	return self->Severity;
}

int so_Message_set_type(so_Message *self, char *value)
{
	if (!value) {
		self->type = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->type);
		self->type = new_value;
		return 0;
	} else {
		return 1;
	}
}

int so_Message_set_Toolname(so_Message *self, char *value)
{
	if (!value) {
		self->Toolname = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->Toolname);
		self->Toolname = new_value;
		return 0;
	} else {
		return 1;
	}
}

int so_Message_set_Name(so_Message *self, char *value)
{
	if (!value) {
		self->Name = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->Name);
		self->Name = new_value;
		return 0;
	} else {
		return 1;
	}
}

int so_Message_set_Content(so_Message *self, char *value)
{
	if (!value) {
		self->Content = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->Content);
		self->Content = new_value;
		return 0;
	} else {
		return 1;
	}
}

void so_Message_set_Severity(so_Message *self, int *value)
{
	if (value) {
		self->Severity_number = *value;
		self->Severity = &(self->Severity_number);
	} else {
		self->Severity = value;
	}
}

int so_Message_xml(so_Message *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->Toolname || self->Name || self->Content || self->Severity || self->type) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "Message");
		if (rc < 0) return 1;
		if (self->type) {
			rc = xmlTextWriterWriteAttribute(writer, BAD_CAST "type", BAD_CAST self->type);
			if (rc < 0) return 1;
		}
		if (self->Toolname) {
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "Toolname", BAD_CAST self->Toolname);
			if (rc < 0) return 1;
		}
		if (self->Name) {
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "Name", BAD_CAST self->Name);
			if (rc < 0) return 1;
		}
		if (self->Content) {
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "Content", BAD_CAST self->Content);
			if (rc < 0) return 1;
		}
		if (self->Severity) {
			char *number_string = pharmml_int_to_string(self->Severity_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "Severity", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_Message_start_element(so_Message *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (strcmp(localname, "Toolname") == 0) {
		self->in_Toolname = 1;
	} else if (strcmp(localname, "Name") == 0) {
		self->in_Name = 1;
	} else if (strcmp(localname, "Content") == 0) {
		self->in_Content = 1;
	} else if (strcmp(localname, "Severity") == 0) {
		self->in_Severity = 1;
	}
	return 0;
}

void so_Message_end_element(so_Message *self, const char *localname)
{
	if (strcmp(localname, "Toolname") == 0 && self->in_Toolname) {
		self->in_Toolname = 0;
	} else if (strcmp(localname, "Name") == 0 && self->in_Name) {
		self->in_Name = 0;
	} else if (strcmp(localname, "Content") == 0 && self->in_Content) {
		self->in_Content = 0;
	} else if (strcmp(localname, "Severity") == 0 && self->in_Severity) {
		self->in_Severity = 0;
	}
}

int so_Message_characters(so_Message *self, const char *ch, int len)
{
	if (self->in_Toolname) {
		self->Toolname = pharmml_strndup(ch, len);
		if (!self->Toolname) {
			return 1;
		}
	} else if (self->in_Name) {
		self->Name = pharmml_strndup(ch, len);
		if (!self->Name) {
			return 1;
		}
	} else if (self->in_Content) {
		self->Content = pharmml_strndup(ch, len);
		if (!self->Content) {
			return 1;
		}
	} else if (self->in_Severity) {
		self->Severity_number = pharmml_string_to_int(ch);
		self->Severity = &(self->Severity_number);
	}
	return 0;
}

int so_Message_init_attributes(so_Message *self, int nb_attributes, const char **attributes)
{
	unsigned int index = 0;
	for (int i = 0; i < nb_attributes; i++, index += 5) {
		const char *localname = attributes[index];
		const char *valueBegin = attributes[index + 3];
		const char *valueEnd = attributes[index + 4];

		if (strcmp(localname, "type") == 0) {
			self->type = pharmml_strndup(valueBegin, valueEnd - valueBegin);
			if (!self->type) {
				return 1;
			}
		}
	}
	return 0;
}
