% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lastrees_dalponte.r
\name{lastrees_dalponte}
\alias{lastrees_dalponte}
\title{Individual tree segmentation}
\usage{
lastrees_dalponte(las, chm, treetops, th_tree = 2, th_seed = 0.45,
  th_cr = 0.55, max_cr = 10, extra = FALSE, ...)
}
\arguments{
\item{las}{An object of the class \code{LAS}. If missing \code{extra} is turned to \code{TRUE}
automatically.}

\item{chm}{RasterLayer. Image of the canopy. Can be computed with \link[lidR:grid_canopy]{grid_canopy}
or \link[lidR:grid_tincanopy]{grid_tincanopy} or read it from an external file.}

\item{treetops}{\code{RasterLayer} or \code{data.frame} containing the position of the
trees. Can be computed with \link[lidR:tree_detection]{tree_detection} or read from an external file.}

\item{th_tree}{numeric. Threshold below which a pixel cannot be a tree. Default 2.}

\item{th_seed}{numeric. Growing threshold 1. See reference in Dalponte et al. 2016. A pixel
is added to a region if its height is greater than the tree height multiplied by this value.
It should be between 0 and 1. Default 0.45.}

\item{th_cr}{numeric. Growing threshold 2. See reference in Dalponte et al. 2016. A pixel
is added to a region if its height is greater than the current mean height of the region
multiplied by this value. It should be between 0 and 1. Default 0.55.}

\item{max_cr}{numeric. Maximum value of the crown diameter of a detected tree (in pixels).
Default 10.}

\item{extra}{logical. By default the function classifies the original point cloud by reference
and return nothing (NULL) i.e. the original point cloud is automatically updated in place. If
\code{extra = TRUE} an additional \code{RasterLayer} used internally can be returned.}

\item{...}{Supplementary options. Currently \code{field} is supported to change the default name of
the new column.}
}
\value{
Nothing (NULL), the point cloud is updated by reference. The original point cloud
has a new column named \code{treeID} containing an ID for each point that refer to a segmented tree.
If \code{extra = TRUE} algorithms return a \code{RasterLayer} used internally.
}
\description{
Individual tree segmentation using Dalponte et al. (2016) algorithm (see reference).
This is a local maxima + growing region algorithm. It is based on the constraints proposed by
Dalponte and Coomes (see references). This algorithm exists in the package \code{itcSegment}.
This version is identical to the original but with superfluous code removed and rewritten
efficiently. Consequently it is hundreds to millions times faster. Note that this algorithm strictly
performs a segmentation, while the original method as implemented in \code{itcSegment} and described
in the manuscript also performs a pre- and post-process when these tasks are expected to be done
by the user in separate functions.
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las = readLAS(LASfile, select = "xyz", filter = "-drop_z_below 0")
col = pastel.colors(200)

chm = grid_canopy(las, res = 0.5, subcircle = 0.3)
chm = as.raster(chm)
kernel = matrix(1,3,3)
chm = raster::focal(chm, w = kernel, fun = mean, na.rm = TRUE)

ttops = tree_detection(chm, 5, 2)
lastrees_dalponte(las, chm, ttops)
plot(las, color = "treeID", colorPalette = col)

}
\references{
Dalponte, M. and Coomes, D. A. (2016), Tree-centric mapping of forest carbon density from
airborne laser scanning and hyperspectral data. Methods Ecol Evol, 7: 1236–1245. doi:10.1111/2041-210X.12575.
}
\seealso{
Other tree_segmentation: \code{\link{lastrees_li2}},
  \code{\link{lastrees_silva}},
  \code{\link{lastrees_watershed}}, \code{\link{lastrees}}
}
