% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_density.r
\name{grid_density}
\alias{grid_density}
\title{Map the pulse or point density}
\usage{
grid_density(las, res = 4)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{res}{numeric. The size of a grid cell in LiDAR data coordinates units. Default is 4 = 16
square meters.}
}
\value{
A \code{RasterLayer} or a \code{RasterBrick} containing a numeric value in each cell. If the
\code{RasterLayer}s are written on disk when running the function with a \code{LAScatalog}, a
virtual raster mosaic is returned (see \link[gdalUtils:gdalbuildvrt]{gdalbuildvrt})
}
\description{
Creates a map of the point density. If a "pulseID" attribute is found, also returns a map of the pulse
density.
}
\section{Working with a \code{LAScatalog}}{

This section appears in each function that supports a LAScatalog as input.\cr

In \code{lidR} when the input of a function is a \link[lidR:LAScatalog-class]{LAScatalog} the
function uses the LAScatalog processing engine. The user can modify the engine options using
the \link[lidR:catalog_options_tools]{available options}. A careful reading of the
\link[lidR:LAScatalog-class]{engine documentation} is recommended before processing \code{LAScatalogs}. Each
\code{lidR} function should come with a section that documents the supported engine options.\cr

The \code{LAScatalog} engine supports \code{.lax} files that \emph{significantly} improve the computation
speed of spatial queries using a spatial index. Users should really take advantage a \code{.lax} files,
but this is not mandatory.\cr
}

\section{Supported processing options}{

Supported processing options for a \code{LAScatalog} in \code{grid_*} functions (in bold). For
more details see the \link[lidR:LAScatalog-class]{LAScatalog engine documentation}:
\itemize{
\item \strong{chunk size}: How much data is loaded at once. The chunk size may be slightly modified
internally to ensure a strict continuous wall-to-wall output even when chunk size is equal to 0
(processing by file).
\item chunk buffer: This function guarantees a strict continuous wall-to-wall output. The
\code{buffer} option is not considered.
\item \strong{chunk alignment}: Align the processed chunks. The alignment may be slightly modified
internally to ensure a strict continuous wall-to-wall output.
\item \strong{progress}: Displays a progress estimate.
\item \strong{output files}: Return the output in R or write each cluster's output in a file.
Supported templates are \code{\{XLEFT\}}, \code{\{XRIGHT\}}, \code{\{YBOTTOM\}}, \code{\{YTOP\}},
\code{\{XCENTER\}}, \code{\{YCENTER\}} \code{\{ID\}} and, if chunk size is equal to 0 (processing
by file), \code{\{ORIGINALFILENAME\}}.
\item \strong{\emph{select}}: The \code{grid_*} functions usually 'know' what should be loaded
and this option is not considered. In \link{grid_metrics} this option is respected.
\item \strong{filter}: Read only the points of interest.
}
}

\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile)

d <- grid_density(las, 5)
plot(d)
d <- grid_density(las, 10)
plot(d)

las <- laspulse(las)
d <- grid_density(las)
plot(d)
}
