% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasfilter.r
\name{lasfilter}
\alias{lasfilter}
\title{Return points with matching conditions}
\usage{
lasfilter(las, ...)
}
\arguments{
\item{las}{An object of class \code{\link[lidR:LAS-class]{LAS}}}

\item{\dots}{Logical predicates. Multiple conditions are combined with '&' or ','}
}
\value{
An object of class \code{\link[lidR:LAS-class]{LAS}}
}
\description{
Return points with matching conditions
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

# Select the first returns classified as ground
firstground = lasfilter(lidar, Classification == 2L & ReturnNumber == 1L)

# Multiple arguments are equivalent to &
firstground = lasfilter(lidar, Classification == 2L, ReturnNumber == 1L)

# Multiple criteria
first_or_ground = lasfilter(lidar, Classification == 2L | ReturnNumber == 1L)
}
\seealso{
Other lasfilters: 
\code{\link{lasfilterduplicates}()},
\code{\link{lasfiltersurfacepoints}()},
\code{\link{lasfilters}}
}
\concept{lasfilters}
