% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character.R, R/dataframe.R, R/explain.R
\name{explain.character}
\alias{explain.character}
\alias{explain.data.frame}
\alias{explain}
\title{Explain model predictions}
\usage{
\method{explain}{character}(x, explainer, labels = NULL, n_labels = NULL,
  n_features, n_permutations = 5000, feature_select = "auto",
  single_explanation = FALSE, ...)

\method{explain}{data.frame}(x, explainer, labels = NULL, n_labels = NULL,
  n_features, n_permutations = 5000, feature_select = "auto",
  dist_fun = "euclidean", kernel_width = NULL, ...)

explain(x, explainer, labels, n_labels = NULL, n_features,
  n_permutations = 5000, feature_select = "auto", ...)
}
\arguments{
\item{x}{New observations to explain, of the same format as used when
creating the explainer}

\item{explainer}{An \code{explainer} object to use for explaining the observations}

\item{labels}{The specific labels (classes) to explain in case the model is
a classifier. For classifiers either this or \code{n_labels} must be given.}

\item{n_labels}{The number of labels to explain. If this is given for
classifiers the top \code{n_label} classes will be explained.}

\item{n_features}{The number of features to use for each explanation.}

\item{n_permutations}{The number of permutations to use for each explanation.}

\item{feature_select}{The algorithm to use for selecting features. One of:
\itemize{
\item \code{"auto"}: If \code{n_features <= 6} use \code{"forward_selection"} else use \code{"highest_weights"}.
\item \code{"none"}: Ignore \code{n_features} and use all features.
\item \code{"forward_selection"}: Add one feature at a time until \code{n_features} is
reached, based on quality of a ridge regression model.
\item \code{"highest_weights"}: Fit a ridge regression and select the \code{n_features} with
the highest absolute weight.
\item \code{"lasso_path"}: Fit a lasso model and choose the \code{n_features} whose lars
path converge to zero the latest.
\item \code{"tree"} : Fit a tree to select \code{n_features} (which needs to be a power of
2). It requires last version of \code{XGBoost}.
}}

\item{single_explanation}{A boolean indicating whether to pool all text in
\code{x} into a single explanation.}

\item{...}{Parameters passed on to the specific explainer}

\item{dist_fun}{The distance function to use for calculating the distance
from the observation to the permutations. Will be forwarded to
\code{\link[stats:dist]{stats::dist()}}}

\item{kernel_width}{The width of the exponential kernel that will be used to
convert the distance to a similarity.}
}
\value{
A data.frame encoding the explanations one row per explained
observation. The columns are:
\itemize{
\item \code{model_type}: The type of the model used for prediction.
\item \code{case}: The case being explained (the rowname in \code{cases}).
\item \code{model_r2}: The quality of the model used for the explanation
\item \code{model_intercept}: The intercept of the model used for the explanation
\item \code{model_prediction}: The prediction of the observation based on the model
used for the explanation.
\item \code{feature}: The feature used for the explanation
\item \code{feature_value}: The value of the feature used
\item \code{feature_weight}: The weight of the feature in the explanation
\item \code{feature_desc}: A human readable description of the feature importance.
\item \code{data}: Original data being explained
\item \code{prediction}: The original prediction from the model
}

Furthermore classification explanations will also contain:
\itemize{
\item \code{label}: The label being explained
\item \code{label_prob}: The probability of \code{label} as predicted by \code{model}
}
}
\description{
Once an explainer has been created using the \code{\link[=lime]{lime()}} function it can be used
to explain the result of the model on new observations. The \code{explain()}
function takes new observation along with the explainer and returns a
data.frame with prediction explanations, one observation per row. The
returned explanations can then be visualised in a number of ways, e.g. with
\code{\link[=plot_features]{plot_features()}}.
}
\examples{
# Explaining a model and an explainer for it
library(MASS)
iris_test <- iris[1, 1:4]
iris_train <- iris[-1, 1:4]
iris_lab <- iris[[5]][-1]
model <- lda(iris_train, iris_lab)
explanation <- lime(iris_train, model)

# This can now be used together with the explain method
explain(iris_test, explanation, n_labels = 1, n_features = 2)

}
