% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charting.R
\name{response_curves}
\alias{response_curves}
\title{response_curves}
\usage{
response_curves(
  model,
  x_min = NULL,
  x_max = NULL,
  y_min = NULL,
  y_max = NULL,
  interval = NULL,
  trans_only = FALSE,
  colors = color_palette(),
  plotly = TRUE,
  verbose = FALSE,
  table = FALSE,
  add_intercept = FALSE,
  points = FALSE
)
}
\arguments{
\item{model}{Model object}

\item{x_min}{number specifying horizontal axis min}

\item{x_max}{number specifying horizontal axis max}

\item{y_min}{number specifying vertical axis min}

\item{y_max}{number specifying vertical axis max}

\item{interval}{number specifying interval between points of the curve}

\item{trans_only}{a boolean specifying whether to display non-linear only \code{y = b*dim_rest(x)}}

\item{colors}{character vector of colors in hexadecimal notation}

\item{plotly}{A boolean to specify whether to include use ggplot over plotly}

\item{verbose}{A boolean to specify whether to print warnings}

\item{table}{A boolean to specify whether to return a \code{data.frame} of the response curves}

\item{add_intercept}{A boolean to specify whether to include the intercept whne calculating the curves}

\item{points}{A boolean to specify whether to include the points from the data on the curve}
}
\value{
a \code{plotly} line chart of the model's response curves
}
\description{
Line chart of variable response curves
}
\details{
Line chart of variable response curves visualising the relationship of each independent variable with the dependent variable
}
\examples{
model = run_model(data = mtcars,dv = 'mpg',ivs = c('disp'))
model \%>\%
   response_curves()
model = run_model(data = mtcars,dv = 'mpg',ivs = c('wt','cyl','disp')) 

model \%>\%
   response_curves()
   
run_model(data = scale(mtcars) \%>\% 
              data.frame(),
          dv = 'mpg',
          ivs = c('wt','cyl','disp')) \%>\%
   response_curves()
}
