% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_run.R
\name{re_run_model}
\alias{re_run_model}
\title{re_run_model}
\usage{
re_run_model(
  model,
  data = NULL,
  dv = NULL,
  ivs = NULL,
  trans_df = NULL,
  id_var = NULL,
  pool_var = NULL,
  model_table = NULL,
  normalise_by_pool = FALSE,
  verbose = FALSE,
  decompose = TRUE
)
}
\arguments{
\item{model}{the model object used as the starting point of the re-run}

\item{data}{\code{data.frame} containing variables included in the model specification}

\item{dv}{string of the dependent variable name}

\item{ivs}{character vector of the independent variables names}

\item{trans_df}{\code{data.frame} defining the non-linear transformations to apply}

\item{id_var}{string of id variable name (e.g. date)}

\item{pool_var}{string of pool variable name (e.g. country)}

\item{model_table}{\code{data.frame} as created in the \code{build_model_table} function}

\item{normalise_by_pool}{A boolean to specify whether to apply the normalisation}

\item{verbose}{A boolean to specify whether to print warnings}

\item{decompose}{A boolean to specify whether to generate the model decomposition}
}
\value{
Model object
}
\description{
Re-run a linear regression model
}
\details{
Re-run a linear regression model using the function output of running \code{linea::run_model}.
}
\examples{
model = run_model(mtcars,ivs = 'cyl', dv = 'mpg',save_all_raw_data = TRUE)
re_run_model(model,ivs = c('disp','cyl','wt'))
}
