% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_tag.R
\name{has_tag}
\alias{has_tag}
\title{A selector function to use in \pkg{tidyverse} functions}
\usage{
has_tag(tags)
}
\arguments{
\item{tags}{A character vector of tags listing the variables you want to
operate on}
}
\value{
A numeric vector containing the position of the columns with the
requested tags
}
\description{
A selector function to use in \pkg{tidyverse} functions
}
\examples{
if (require(outbreaks) && require(dplyr)) {

  ## dataset we'll create a linelist from
  measles_hagelloch_1861

  ## create linelist
  x <- make_linelist(measles_hagelloch_1861,
    id = "case_ID",
    date_onset = "date_of_prodrome",
    age = "age",
    gender = "gender"
  )
  head(x)

  x \%>\%
    select(has_tag(c("id", "age"))) \%>\%
    head()
}
}
