% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqDGP.R
\name{lineqDGPSys}
\alias{lineqDGPSys}
\title{Linear Systems of Inequalities for \code{"lineqDGP"} Models}
\usage{
lineqDGPSys(d, constrType = c("boundedness", "monotonicity",
  "convexity"), l = -Inf, u = Inf, lineqSysType = "twosides",
  rmInf = TRUE)
}
\arguments{
\item{d}{the number of linear inequality constraints.}

\item{constrType}{a character string corresponding to the type of the inequality constraint.
Options: "boundedness", "monotonicity", "convexity".}

\item{l}{the value (or vector) with the lower bound.}

\item{u}{the value (or vector) with the upper bound.}

\item{lineqSysType}{a character string corresponding to the type of the
linear system. Options: \code{twosides}, \code{oneside} (see \code{\link{bounds2lineqSys}} for more details).}

\item{rmInf}{If \code{TRUE}, inactive constraints are removed
(e.g. \eqn{-\infty \leq x \leq \infty}{-Inf \le x \le Inf}).}
}
\value{
A list with the linear system of inequalities: \code{list(A,l,u)} (\code{twosides}) or \code{list(M,g)} (\code{oneside} ).
}
\description{
Build the linear system of inequalities for \code{"lineqDGP"} models.
}
\examples{
linSys1 <- lineqDGPSys(d = 5, constrType = "boundedness", l = 0, u = 1, lineqSysType = "twosides")
linSys1
linSys2 <- lineqDGPSys(d = 5, constrType = "boundedness", l = 0, u = 1, lineqSysType = "oneside")
linSys2

}
\references{
Maatouk, H. and Bay, X. (2017),
"Gaussian process emulators for computer experiments with inequality constraints".
\emph{Mathematical Geosciences},
49(5):557-582.
\href{https://link.springer.com/article/10.1007/s11004-017-9673-2}{[link]}
}
\seealso{
\code{\link{bounds2lineqSys}}
}
\author{
A. F. Lopez-Lopera.
}
