% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqAGP.R
\name{basisCompute.lineqAGP}
\alias{basisCompute.lineqAGP}
\title{Hat Basis Functions for \code{"lineqAGP"} Models}
\usage{
basisCompute.lineqAGP(x, u, d = 1)
}
\arguments{
\item{x}{a vector (or matrix) with the input data.}

\item{u}{a vector (or matrix) with the locations of the knots.}

\item{d}{a number corresponding to the dimension of the input space.}
}
\value{
A matrix with the hat basis functions. The basis functions are indexed by rows.
}
\description{
Evaluate the hat basis functions for \code{"lineqAGP"} models.
}
\section{Comments}{

This function was tested mainly for 1D or 2D input spaces. It could change
in future versions for higher dimensions.
}

\examples{
x <- seq(0, 1, 1e-3)
m <- 5
u <- seq(0, 1, 1/(m-1))
Phi <- basisCompute.lineqAGP(x, u, d = 1)
matplot(Phi, type = "l", lty = 2, main = "Hat basis functions with m = 5")

}
\references{
Lopez-Lopera, A. F., Bachoc, F., Durrande, N., and Roustant, O. (2017),
"Finite-dimensional Gaussian approximation with linear inequality constraints".
\emph{ArXiv e-prints}
\href{https://arxiv.org/abs/1710.07453}{[link]}

Maatouk, H. and Bay, X. (2017),
"Gaussian process emulators for computer experiments with inequality constraints".
\emph{Mathematical Geosciences},
49(5): 557-582.
\href{https://link.springer.com/article/10.1007/s11004-017-9673-2}{[link]}
}
\author{
A. F. Lopez-Lopera.
}
