% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPsamplers.R
\name{tmvrnorm.ExpT}
\alias{tmvrnorm.ExpT}
\title{\code{"tmvrnorm"} Sampler for \code{"ExpT"} (Exponential Tilting) S3 Class}
\usage{
\method{tmvrnorm}{ExpT}(object, nsim, control = NULL, ...)
}
\arguments{
\item{object}{an object with \code{"ExpT"} S3 class containing:
\code{mu} (mean vector), \code{Sigma} (covariance matrix),
\code{lb} (lower bound vector), \code{ub} (upper bound vector).}

\item{nsim}{an integer corresponding to the number of simulations.}

\item{control}{extra parameters required for the MC/MCMC sampler.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix with the simulated samples. Samples are indexed by columns.
}
\description{
Sampler for truncated multivariate normal distributions
via exponential tilting using the package \code{TruncatedNormal} (Botev, 2017).
}
\examples{
n <- 100
x <- seq(0, 1, length = n)
Sigma <- kernCompute(x1 = x, type = "gaussian", par = c(1,0.2))
tmgPar <- list(mu = rep(0,n), Sigma = Sigma + 1e-9*diag(n), lb = rep(-1,n), ub = rep(1,n))
class(tmgPar) <- "ExpT"
y <- tmvrnorm(tmgPar, nsim = 10)
matplot(x, y, type = 'l', ylim = c(-1,1),
        main = "Constrained samples using expontial tilting")
abline(h = c(-1,1), lty = 2)

}
\references{
Botev, Z. I. (2017),
"The normal law under linear restrictions: simulation and estimation via minimax tilting".
\emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)},
79(1):125-148.
\href{https://rss.onlinelibrary.wiley.com/doi/pdf/10.1111/rssb.12162}{[link]}
}
\seealso{
\code{\link{tmvrnorm.RSM}}, \code{\link{tmvrnorm.HMC}}
}
\author{
A. F. Lopez-Lopera.
}
