% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPsamplers.R
\name{tmvrnorm.RSM}
\alias{tmvrnorm.RSM}
\title{\code{"tmvrnorm"} Sampler for \code{"RSM"} (Rejection Sampling from the Mode) S3 Class}
\usage{
\method{tmvrnorm}{RSM}(object, nsim, control = NULL, ...)
}
\arguments{
\item{object}{an object with \code{"RSM"} S3 class containing:
\code{mu} (mean vector), \code{Sigma} (covariance matrix),
\code{lb} (lower bound vector), \code{ub} (upper bound vector).}

\item{nsim}{an integer corresponding to the number of simulations.}

\item{control}{extra parameters required for the MC/MCMC sampler.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix with the simulated samples. Samples are indexed by columns.
}
\description{
Sampler for truncated multivariate normal distributions
via RSM according to (Maatouk and Bay, 2017).
}
\examples{
n <- 100
x <- seq(0, 1, length = n)
Sigma <- kernCompute(x1 = x, type = "gaussian", par = c(1,0.2))
tmgPar <- list(mu = rep(0,n), Sigma = Sigma + 1e-9*diag(n), lb = rep(-1,n), ub = rep(1,n))
class(tmgPar) <- "RSM"
y <- tmvrnorm(tmgPar, nsim = 10)
matplot(x, y, type = 'l', ylim = c(-1,1),
        main = "Constrained samples using RSM")
abline(h = c(-1,1), lty = 2)

}
\references{
Maatouk, H. and Bay, X. (2017),
"Gaussian process emulators for computer experiments with inequality constraints".
\emph{Mathematical Geosciences},
49(5):557-582.
\href{https://link.springer.com/article/10.1007/s11004-017-9673-2}{[link]}
}
\seealso{
\code{\link{tmvrnorm.HMC}}, \code{\link{tmvrnorm.ExpT}}
}
\author{
A. F. Lopez-Lopera.
}
