% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initProj.R
\name{initProj}
\alias{initProj}
\title{Defines and creates folders and variables}
\usage{
initProj(
  projRootDir = tempdir(),
  GRASSlocation = "tmp/",
  projFolders = c("data/", "result/", "run/", "log/"),
  path_prefix = "",
  global = FALSE
)
}
\arguments{
\item{projRootDir}{project github root directory (your github name)}

\item{GRASSlocation}{folder for GRASS data}

\item{projFolders}{list of subfolders in project}

\item{path_prefix}{character a prefix for the path variables names default is ""}

\item{global}{boolean esport path strings as global variables default is false}
}
\description{
Defines and creates (if necessary) all folders variables. Returns a list with the project folder pathes. Optionally exports all pathes to a global sub environment.
}
\examples{
\dontrun{

link2GI::initProj(projRootDir = tempdir(),
                 projFolders = c("data/",
                                 "data/level0/",
                                 "data/level1/",
                                  "output/",
                                  "run/",
                                  "fun/") )
}   
}
