% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasibility.R
\name{is_feasible}
\alias{is_feasible}
\title{Check feasibility of a system of linear (in)equations}
\usage{
is_feasible(A, b, neq = nrow(A), nleq = 0, eps = 1e-08,
  method = "elimination")
}
\arguments{
\item{A}{[\code{numeric}] matrix}

\item{b}{[\code{numeric}] vector}

\item{neq}{[\code{numeric}] The first \code{neq} rows in \code{A} and
\code{b} are treated as linear equalities.}

\item{nleq}{[\code{numeric}] The \code{nleq} rows after \code{neq} are treated as
inequations of the form \code{a.x<=b}. All remaining rows are treated as strict inequations
of the form \code{a.x<b}.}

\item{eps}{[\code{numeric}] Absolute values \code{< eps} are treated as zero.}

\item{method}{[\code{character}] At the moment, only the 'elimination' method is implemented.}
}
\description{
Check feasibility of a system of linear (in)equations
}
\examples{
# An infeasible system:
# x + y == 0
# x > 0
# y > 0
A <- matrix(c(1,1,1,0,0,1),byrow=TRUE,nrow=3)
b <- rep(0,3)
is_feasible(A=A,b=b,neq=1,nleq=0)

# A feasible system:
# x + y == 0
# x >= 0
# y >= 0
A <- matrix(c(1,1,1,0,0,1),byrow=TRUE,nrow=3)
b <- rep(0,3)
is_feasible(A=A,b=b,neq=1,nleq=2)

}
