% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_with_token.R, R/with_id.R
\name{ids_with_token}
\alias{ids_with_token}
\alias{with_id}
\title{Get parsed IDs by token}
\usage{
ids_with_token(source_file, value, fun = `==`)

with_id(source_file, id)
}
\arguments{
\item{source_file}{A list of source expressions, the result of a call to
`\link{get_source_expressions}()`, for the desired filename.}

\item{value}{Character. String correspondin to the token to search for.
For example:
\itemize{
  \item "SYMBOL"
  \item "FUNCTION"
  \item "EQ_FORMALS"
  \item "$"
  \item "("
}}

\item{fun}{For additionaly flexibility, a function to search for in
the `token` column of `parsed_content`. Typically `==` or `\%in\%`.}

\item{id}{Integer. The index corresponding to the desired row
of `parsed_content`.}
}
\value{
`ids_with_token`: The indices of the `parsed_content` data frame
entry of the list of source expressions. Indices correspond to the
*rows* where `fun` evaluates to `TRUE` for the `value` in the *token* column.

`with_id`: A data frame corresponding to the row(s) specified in `id`.
}
\description{
Gets the source IDs (row indices) corresponding to given token.
}
\section{Functions}{
\itemize{
\item \code{with_id}: Return the row of the `parsed_content` entry of the
`\link{get_source_expressions}()` object. Typically used in conjunction with
`ids_with_token` to iterate over rows containing desired tokens.
}}

