% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr.R
\name{mlr-liquidSVM}
\alias{mlr-liquidSVM}
\alias{makeRLearner.regr.liquidSVM}
\alias{trainLearner.regr.liquidSVM}
\alias{predictLearner.regr.liquidSVM}
\alias{makeRLearner.classif.liquidSVM}
\alias{trainLearner.classif.liquidSVM}
\alias{predictLearner.classif.liquidSVM}
\title{liquidSVM functions for mlr}
\usage{
makeRLearner.regr.liquidSVM()

trainLearner.regr.liquidSVM(.learner, .task, .subset, .weights = NULL,
  partition_choice = 0, partition_param = -1, ...)

predictLearner.regr.liquidSVM(.learner, .model, .newdata, ...)

makeRLearner.classif.liquidSVM()

trainLearner.classif.liquidSVM(.learner, .task, .subset, .weights = NULL,
  partition_choice = 0, partition_param = -1, ...)

predictLearner.classif.liquidSVM(.learner, .model, .newdata, ...)
}
\arguments{
\item{.learner}{see mlr-Documentation}

\item{.task}{see mlr-Documentation}

\item{.subset}{see mlr-Documentation}

\item{.weights}{see mlr-Documentation}

\item{partition_choice}{the partition choice, see \link{Configuration}}

\item{partition_param}{a further param for partition choice, see \link{Configuration}}

\item{...}{other parameters, see \link{Configuration}}

\item{.model}{the trained mlr-model, see mlr-Documentation}

\item{.newdata}{the test features, see mlr-Documentation}
}
\description{
Allow for liquidSVM \code{\link{lsSVM}} and \code{\link{mcSVM}}
to be used in the \code{mlr} framework.
}
\note{
In order that mlr can find our learners liquidSVM has to be loaded
using e.g. \code{library(liquidSVM)}
\code{model <- train(...)}
}
\examples{
\dontrun{
if(require(mlr)){
library(liquidSVM)

## Define a regression task
task <- makeRegrTask(id = "trees", data = trees, target = "Volume")
## Define the learner
lrn <- makeLearner("regr.liquidSVM", display=1)
## Train the model use mlr::train to get the correct train function
model <- train(lrn,task)
pred <- predict(model, task=task)
performance(pred)

## Define a classification task
task <- makeClassifTask(id = "iris", data = iris, target = "Species")

## Define the learner
lrn <- makeLearner("classif.liquidSVM", display=1)
model <- train(lrn,task)
pred <- predict(model, task=task)
performance(pred)

## or for probabilities
lrn <- makeLearner("classif.liquidSVM", display=1, predict.type='prob')
model <- train(lrn,task)
pred <- predict(model, task=task)
performance(pred)

} # end if(require(mlr))
}
}
