% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queue.R
\name{ensure_queue}
\alias{ensure_queue}
\title{Make sure that a queue exists}
\usage{
ensure_queue(name, db = default_db(), crash_strategy = "fail")
}
\arguments{
\item{name}{Name of the queue. If not specified or \code{NULL}, a
name is generated randomly.}

\item{db}{Path to the database file.}

\item{crash_strategy}{What to do with crashed jobs. The default is that
they will \code{"fail"} (just like a negative acknowledgement). Another
possibility is \code{"requeue"}, in which case they are requeued
immediately, potentially even multiple times. Alternatively it can be
a number, in which case they are requeued at most the specified number
of times.}
}
\value{
The queue object.
}
\description{
If it does not exist, then the queue will be created.
}
\seealso{
\link{liteq} for examples

Other liteq queues: \code{\link{create_queue}},
  \code{\link{delete_queue}}, \code{\link{list_queues}}
}
