% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oos_realized_forc.R
\name{oos_realized_forc}
\alias{oos_realized_forc}
\title{Out-of-sample linear model forecast conditioned on realized values}
\usage{
oos_realized_forc(
  lm_call,
  h_ahead,
  estimation_end,
  time_vec = NULL,
  estimation_window = NULL
)
}
\arguments{
\item{lm_call}{Linear model call of the class lm.}

\item{h_ahead}{Integer representing the number of periods ahead that is being
forecasted.}

\item{estimation_end}{Value of any class representing when to end the initial
coefficient estimation period and begin forecasting.}

\item{time_vec}{Vector of any class that is equal in length to the data
in \code{lm_call}.}

\item{estimation_window}{Integer representing the number of past periods
that the linear model should be estimated over in each period.}
}
\value{
\code{\link{Forecast}} object that contains the out-of-sample
forecast.
}
\description{
\code{oos_realized_forc} takes a linear model call, an integer number of
periods ahead to forecast, a period to end the initial coefficient estimation
and begin forecasting, an optional vector of time data associated with
the linear model, and an optional integer number of past periods to estimate
the linear model over. The linear model is originally estimated with data up
to \code{estimation_end} minus the number of periods specified in
\code{estimation_window}. If \code{estimation_window} is left \code{NULL}
then the linear model is estimated with all available data up to
\code{estimation_end}. Coefficients are multiplied by realized values of the
covariates \code{h_ahead} periods ahead to create an \code{h_ahead} period
ahead forecast. This process is iteratively repeated for each period after
\code{estimation_end} with coefficients updating in each period. Returns an
out-of-sample forecast conditional on realized values that \strong{would not}
have been available at the forecast origin. Tests the out-of-sample
performance of a linear model had it been conditioned on perfect information.
}
\examples{
date <- as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                  "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                  "2012-03-31", "2012-06-30"))
y  <- c(1.09, 1.71, 1.09, 2.46, 1.78, 1.35, 2.89, 2.11, 2.97, 0.99)
x1 <- c(4.22, 3.86, 4.27, 5.60, 5.11, 4.31, 4.92, 5.80, 6.30, 4.17)
x2  <- c(10.03, 10.49, 10.85, 10.47, 9.09, 10.91, 8.68, 9.91, 7.87, 6.63)
data <- data.frame(date, y, x1, x2)

oos_realized_forc(
  lm_call = lm(y ~ x1 + x2, data),
  h_ahead = 2L,
  estimation_end = as.Date("2011-03-31"),
  time_vec = data$date,
  estimation_window = NULL
)

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
