% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clpca.R
\name{clpca}
\alias{clpca}
\title{Cumulative Logistic (Restrcited) PCA}
\usage{
clpca(
  Y,
  X = NULL,
  S = 2,
  lambda = FALSE,
  trace = FALSE,
  maxiter = 65536,
  dcrit = 1e-06
)
}
\arguments{
\item{Y}{An N times R ordinal matrix  .}

\item{X}{An N by P matrix with predictor variables}

\item{S}{Positive number indicating the dimensionality of the solution}

\item{lambda}{if TRUE does lambda scaling (see Understanding Biplots, p24)}

\item{trace}{tracing information during iterations}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}
}
\value{
Y Matrix Y from input

Xoriginal Matrix X from input

X Scaled X matrix

mx Mean values of X

sdx Standard deviations of X

ynames Variable names of responses

xnames Variable names of predictors

probabilities Estimated values of Y

m main effects

U matrix with coordinates for row-objects

B matrix with regression weight (U = XB)

V matrix with vectors for items/responses

iter number of main iterations from the MM algorithm

deviance value of the deviance at convergence
}
\description{
Cumulative Logistic (Restrcited) PCA
}
\examples{
\dontrun{
data(dataExample_clpca)
Y<-as.matrix(dataExample_clpca[,5:8])
X<-as.matrix(dataExample_clpca[,1:4])
out = clpca(Y)
out = clpca(Y, X)
}

}
