% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpca.R
\name{lpca}
\alias{lpca}
\title{Logistic (Restricted) PCA}
\usage{
lpca(
  Y,
  X = NULL,
  S = 2,
  dim.indic = NULL,
  eq = FALSE,
  lambda = FALSE,
  maxiter = 65536,
  dcrit = 1e-06
)
}
\arguments{
\item{Y}{An N times R binary matrix  .}

\item{X}{An N by P matrix with predictor variables}

\item{S}{Positive number indicating the dimensionality of the solution}

\item{dim.indic}{An R by S matrix indicating which response variable pertains to which dimension}

\item{eq}{Only applicable when dim.indic not NULL; equality restriction on regression weighhts per dimension}

\item{lambda}{if TRUE does lambda scaling (see Understanding Biplots, p24)}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}
}
\value{
This function returns an object of the class \code{lpca} with components:
\item{call}{Call to the function}
\item{Y}{Matrix Y from input}
\item{Xoriginal}{Matrix X from input}
\item{X}{Scaled X matrix}
\item{mx}{Mean values of X}
\item{sdx}{Standard deviations of X}
\item{ynames}{Variable names of responses}
\item{xnames}{Variable names of predictors}
\item{probabilities}{Estimated values of Y}
\item{m}{main effects}
\item{U}{matrix with coordinates for row-objects}
\item{B}{matrix with regression weight (U = XB)}
\item{V}{matrix with vectors for items/responses}
\item{iter}{number of main iterations from the MM algorithm}
\item{deviance}{value of the deviance at convergence}
\item{npar}{number of estimated parameters}
\item{AIC}{Akaike's Information Criterion}
\item{BIC}{Bayesian Information Criterion}
}
\description{
This function runs:
logistic principal component analysis (if X = NULL)
logistic reduced rank regression (if X != NULL)
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_lpca[, 1:8])
X = as.matrix(dataExample_lpca[, 9:13])
# unsupervised
output = lpca(Y = Y, S = 2)
}


}
