% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initbeta.R
\name{init.beta}
\alias{init.beta}
\title{Evaluate fixed effects initial values for lmmen}
\usage{
init.beta(dat, method = c("glmnet", "lme4"))
}
\arguments{
\item{dat}{data.frame, data to solve initial values}

\item{method}{character, method to use, c('glmnet','lme4')}
}
\value{
numeric
}
\description{
Evaluate fixed effects initial values for lmmen via cv.glmnet or lme4.
}
\details{
cv.glmnet is set to ridge regression.
}
\examples{
 dat <- initialize_example(n.i = 5,n = 30,q=4,seed=1)
 init.beta(dat,method='glmnet')
 init.beta(dat,method='lme4')
}
\seealso{
\code{\link[glmnet]{cv.glmnet}}
}
